const API_BASE = "https://countershift-web-v2.onrender.com";

document.addEventListener('DOMContentLoaded', async () => {
    const dealsList = document.getElementById('deals-list');
    const loading = document.getElementById('loading');

    try {
        const response = await fetch(`${API_BASE}/api/Deals/Latest`);
        const deals = await response.json();

        loading.style.display = 'none';

        if (deals.length === 0) {
            dealsList.innerHTML = '<p style="text-align:center; color:#666;">No active deals found.</p>';
            return;
        }

        deals.forEach(deal => {
            const item = document.createElement('a');
            item.href = `${API_BASE}/Home/Details/${deal.id}`;
            item.target = '_blank';
            item.className = 'deal-item';
            
            const imageUrl = deal.imageUrl || 'https://via.placeholder.com/60';
            
            item.innerHTML = `
                <img src="${imageUrl}" class="deal-img">
                <div class="deal-info">
                    <div class="deal-name">${deal.name}</div>
                    <div class="deal-price">
                        ${deal.currency} ${deal.currentPrice}
                        ${deal.discountPercentage > 0 ? `<span class="deal-badge">-${deal.dealBadge || deal.discountPercentage + '%'}</span>` : ''}
                    </div>
                    <div style="font-size:10px; color:#aaa; margin-top:2px;">via ${deal.affiliateName}</div>
                </div>
            `;
            dealsList.appendChild(item);
        });
    } catch (error) {
        console.error('Error fetching deals:', error);
        loading.innerHTML = '<span style="color:#dc3545;">Connection failed.</span>';
    }
});
