// Detect if we are on a known retail site and check our API
const currentUrl = window.location.href;
const API_BASE = "https://countershift-web-v2.onrender.com";

console.log("CounterShift AI: Active on page.");

async function checkCurrentPage() {
    try {
        const response = await fetch(`${API_BASE}/api/Deals/Check?url=${encodeURIComponent(currentUrl)}`);
        if (response.ok) {
            const data = await response.json();
            showNotification(data);
        }
    } catch (e) {
        // Silent fail for background check
    }
}

function showNotification(deal) {
    const banner = document.createElement('div');
    banner.style.cssText = `
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        background: #0d6efd;
        color: white;
        padding: 10px 20px;
        z-index: 999999;
        display: flex;
        justify-content: space-between;
        align-items: center;
        font-family: sans-serif;
        box-shadow: 0 2px 10px rgba(0,0,0,0.3);
        border-bottom: 2px solid #0a58ca;
    `;

    banner.innerHTML = `
        <div style="display:flex; align-items:center;">
            <span style="font-weight:bold; margin-right:15px;">COUNTERSHIFT AI:</span>
            <span>Matched Deal Found! <strong>${deal.name}</strong> for <strong>$${deal.currentPrice}</strong></span>
        </div>
        <div>
            <a href="${deal.affiliateLink}" target="_blank" style="background:white; color:#0d6efd; padding:5px 15px; border-radius:4px; text-decoration:none; font-weight:bold; margin-right:10px;">GET DEAL</a>
            <button id="cs-close" style="background:transparent; border:none; color:white; cursor:pointer; font-size:20px;">&times;</button>
        </div>
    `;

    document.body.prepend(banner);
    
    document.getElementById('cs-close').onclick = () => banner.remove();
}

// Run check
if (currentUrl.includes("amazon.com") || currentUrl.includes("ebay.com")) {
    checkCurrentPage();
}
